/* 
 * npeserv.c
 *
 * Моделює роботу сервера служби "Луна" на базі іменованих каналів
 * (із зворотним зв'язком між сервером і клієнтом).
 * Отримані від клієнта повідомлення повертає назад клієнту.
 * Ілюструє порядок застосування іменованих каналів.
 *
 */

#include "npe.h"

#define PERM    0666
#define ERRLOG "npeserv.err"    /* Журнал повідомлень про помилки */


int main()
{
        char buf[BUFSIZE]; 	
        int pdr, pdw;

        /* Зв'язує стандартний потік виведення повідомлень про помилки
           з файлом ERRLOG (потрібно, оскільки може працювати в фоновому
           режимі). */
        if (freopen(ERRLOG, "w", stderr) == NULL) {
                perror("freopen(ERRLOG, ...)");
                exit(EXIT_FAILURE);
        }    

        /* Створює іменовані канали (якщо вони не існують). */
        if ((mkfifo(PIPE_TO_SERVER, PERM) != 0) && (errno != EEXIST)) {
                perror("mkfifo(PIPE_TO_SERVER, ...)");
                exit(EXIT_FAILURE);
        }
        if ((mkfifo(PIPE_FROM_SERVER, PERM) != 0) && (errno != EEXIST)) {
                perror("mkfifo(PIPE_FROM_SERVER, ...)");
                if (unlink(PIPE_TO_SERVER) != 0)
                        perror("unlink(PIPE_TO_SERVER)");
                exit(EXIT_FAILURE);
        }

        /* Відкриває на читання іменований канал, призначений для передачі
           повідомлень від клієнта серверу. */
        pdr = open(PIPE_TO_SERVER, O_RDONLY);
        if (pdr < 0) {
                perror("open(PIPE_TO_SERVER, ...)");
                if (unlink(PIPE_TO_SERVER) != 0)
                        perror("unlink(PIPE_TO_SERVER)");
                if (unlink(PIPE_FROM_SERVER) != 0)
                        perror("unlink(PIPE_FROM_SERVER)");
                exit(EXIT_FAILURE);
        }
        /* Відкриває на запис іменований канал, призначений для передачі
           повідомлень від сервера клієнту. */
        pdw = open(PIPE_FROM_SERVER, O_WRONLY);
        if (pdw < 0) {
                perror("open(PIPE_FROM_SERVER, ...)");
                if (unlink(PIPE_TO_SERVER) != 0)
                        perror("unlink(PIPE_TO_SERVER)");
                if (unlink(PIPE_FROM_SERVER) != 0)
                        perror("unlink(PIPE_FROM_SERVER)");
                exit(EXIT_FAILURE);
        }	

        /* Видаляє з файлової системи посилання на іменовані канали. */
        if (unlink(PIPE_TO_SERVER) != 0)
                perror("unlink(PIPE_TO_SERVER)");
        if (unlink(PIPE_FROM_SERVER) != 0)
                perror("unlink(PIPE_FROM_SERVER)");

        while (1) {
                int count;
                
                /* Отримує від клієнта повідомлення. */
                count = read(pdr, buf, BUFSIZE);
                if (count < 0) {
                        perror("read()");
                        exit(EXIT_FAILURE);
                }
                if (count == 0) 
                        /* Клієнт закрив канал. */
                        break;
                /* Повертає повідомлення клієнту. */
                if (write(pdw, buf, BUFSIZE) < 0) { 
                        perror("write()");
                        exit(EXIT_FAILURE);
                }    
        }

        exit(EXIT_SUCCESS);
}
